---
title: Chattts API Usage Guide
createdAt: Thu Jul 18 2024 06:12:37 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 13:40:04 GMT+0000 (Coordinated Universal Time)
---

# Chattts API Usage Guide

## Introduction

This document will guide developers on how to use the aonweb library to call the Chattts API, The “chat-tts” likely refers to a model that combines chat capabilities with text-to-speech (TTS) technology, enabling more natural and human-like voice output. This type of model takes text input from users and generates synthesized speech, enhancing the interaction with the machine by making it more lively and realistic.

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Basic Usage

### 1. Import Required Modules

```js
import { AI, AIOptions } from 'aonweb';
```

### 2. Initialize AI Instance

```js
const ai_options = new AIOptions({
    appId: 'your_app_id_here',
    dev_mode: true
});

const aonweb = new AI(ai_options);
```

### 3. Prepare Input Data Example

```js
const data = {
   input:{
    "text": "chat T T S 是一款强大的对话式文本转语音模型。它有中英混读和多说话人的能力。\nchat T T S 不仅能够生成自然流畅的语音，还能控制[laugh]笑声啊[laugh]，\n停顿啊[uv_break]语气词啊等副语言现象[uv_break]。这个韵律超越了许多开源模型[uv_break]。\n请注意，chat T T S 的使用应遵守法律和伦理准则，避免滥用的安全风险。[uv_break]",
    "top_k": 20,
    "top_p": 0.7,
    "voice": 2222,
    "prompt": "",
    "skip_refine": 0,
    "temperature": 0.3,
    "custom_voice": 0
  }
};
```

```js
const data = {
   input:{
      "text": "chat T T S is a text to speech model designed for dialogue applications. \\n[uv_break]it supports mixed language input [uv_break]and offers multi speaker \\ncapabilities with precise control over prosodic elements [laugh]like like \\n[uv_break]laughter[laugh], [uv_break]pauses, [uv_break]and intonation. \\n[uv_break]it delivers natural and expressive speech,[uv_break]so please\\n[uv_break] use the project responsibly at your own risk.[uv_break]",
      "top_k": 20,
      "top_p": 0.7,
      "voice": 2222,
      "prompt": "",
      "skip_refine": 0,
      "temperature": 0.3,
      "custom_voice": 0
    }
};
```

### 4. Call the AI Model

```js
const price = 8; // Cost of the AI call
try {
    const response = await aonweb.prediction("/predictions/ai/chat-tts@thlz998", data, price);
    // Handle response
    console.log("Chattts result:", response);
} catch (error) {
    // Error handling
    console.error("Error generating :", error);
}
```

### Parameter Description

- `text`: String, Text to be synthesized
- `top_k`: Number, Top-k sampling parameter
- `top_p`: Number, Top-p sampling parameter
- `voice`: Number, Voice identifier
- `prompt`:String,Prompt for refining text
- `skip_refine`:Number,Skip refine text step
- `temperature`:Number,Temperature for sampling
- `custom_voice`:Number,Custom voice identifier

### Notes

- Ensure that the provided text is of good quality to achieve the best inference results.
- The API may take some time to process the input and generate the result, consider implementing appropriate wait or loading states.
- Handle possible errors, such as network issues, invalid input, or API limitations.
- Adhere to the terms of use and privacy regulations.

### Example Response

The API response will contain the URL of the generated text-to-speech output or other relevant information. Parse and use the response data according to the actual API documentation.

